﻿namespace UploadTestApi;

interface

uses System.Collections.Specialized,
     System.Net,
     System.IO,
     System.Text,
     System.Xml,
     System.Security.Cryptography.X509Certificates;

type
  ConsoleApp = class
  const SERVER = 'https://online3.postservis.cz';
  public
    class method Main(args: array of String);   
    method HttpUploadFile(url: System.String; file: System.String; paramName: System.String; contentType: System.String; nvc: NameValueCollection);
    method HttpPost(url: System.String; contentType: System.String; nvc: NameValueCollection; nameRes: System.String);
    method parseXml(file: System.String; el: System.String): System.String;   
  end;

 
implementation

method ConsoleApp.parseXml(file: System.String; el: System.String): System.String; 
begin 
var element:System.String;
var hodnota: System.String;
using reader: XmlReader := XmlReader.Create(file) do begin  
  while reader.Read() do begin

   if reader.NodeType = XmlNodeType.Element then begin
      element := reader.Name;     
           if element = 'chyby' then
             hodnota:= reader.GetAttribute('stav');      
   end
    else if reader.NodeType = XmlNodeType.Text then begin
     case element of      
       el: begin
         if hodnota = '0' then
             exit reader.Value
         else
             exit '';
       end;     
      end;      
     end;     
    end;
  end;
end;

method ConsoleApp.HttpUploadFile(url: System.String; file: System.String; paramName: System.String; contentType: System.String; nvc: NameValueCollection);
begin  
  Console.WriteLine(System.String.Format('Probiha nahrani souboru {0} na server {1}', file, url));
  var boundary: System.String := '---------------------------' + DateTime.Now.Ticks.ToString('x');
  var boundarybytes: array of System.Byte := System.Text.Encoding.ASCII.GetBytes(#13#10'--' + boundary + #13#10);

  var wr: HttpWebRequest := WebRequest.Create(url) as HttpWebRequest;
  wr.ContentType := 'multipart/form-data; boundary=' + boundary;
  wr.Method := 'POST';
  wr.KeepAlive := true;
  wr.Credentials := System.Net.CredentialCache.DefaultCredentials;

  var rs: Stream := wr.GetRequestStream();

  var formdataTemplate: System.String := 'Content-Disposition: form-data; name="{0}"'#13#10#13#10'{1}';
  for each key: System.String in nvc.Keys do begin
    rs.Write(boundarybytes, 0, boundarybytes.Length);
    var formitem: System.String := System.String.Format(formdataTemplate, key, nvc[key]);
    var formitembytes: array of System.Byte := System.Text.Encoding.UTF8.GetBytes(formitem);
    rs.Write(formitembytes, 0, formitembytes.Length)
  end;
  rs.Write(boundarybytes, 0, boundarybytes.Length);

  var headerTemplate: System.String := 'Content-Disposition: form-data; name="{0}"; filename="{1}"'#13#10'Content-Type: {2}'#13#10#13#10;
  var header: System.String := System.String.Format(headerTemplate, paramName, file, contentType);
  var headerbytes: array of System.Byte := System.Text.Encoding.UTF8.GetBytes(header);
  rs.Write(headerbytes, 0, headerbytes.Length);

  var fileStream: FileStream := new FileStream(file, FileMode.Open, FileAccess.Read);
  var buffer: array of System.Byte := new System.Byte[4096];
  var bytesRead: System.Int32 := 0;
  bytesRead := fileStream.Read(buffer, 0, buffer.Length);
  while bytesRead > 0 do begin
    rs.Write(buffer, 0, bytesRead);
    bytesRead := fileStream.Read(buffer, 0, buffer.Length)
  end;
  fileStream.Close();

  var trailer: array of System.Byte := System.Text.Encoding.ASCII.GetBytes(#13#10'--' + boundary + '--'#13#10);
  rs.Write(trailer, 0, trailer.Length);
  rs.Close();
 
  var wresp: WebResponse := nil;
  try
    wresp := wr.GetResponse();
    var stream2: Stream := wresp.GetResponseStream();
    var reader2: StreamReader := new StreamReader(stream2); 
   
    var sWriter: System.IO.StreamWriter := new System.IO.StreamWriter('response.xml',true,Encoding.GetEncoding('utf-8'));
    sWriter.Write(reader2.ReadToEnd());    
    sWriter.Close();
        
    Console.WriteLine('Soubor byl nahran na server');
    Console.WriteLine('Vysledek byl zapsan do souboru response.xml');
    Console.WriteLine('HOTOVO!!!');
  finally
    wr := nil
  except
    on ex: Exception do begin      
      Console.WriteLine('Chyba pri nahravani souboru na server: ' + ex.Message);
      if wresp <> nil then begin
        wresp.Close();
        wresp := nil
      end
    end;
  end
end;

method ConsoleApp.HttpPost(url: System.String; contentType: System.String; nvc: NameValueCollection; nameRes: System.String);
begin 
   
  var formdataTemplate: System.String := '{0}={1}&';
  var postData: System.String := '';
  for each key: System.String in nvc.Keys do   
    postData:= postData + System.String.Format(formdataTemplate, key, nvc[key]);  
   
    postData.Substring(0,postData.Length - 1);

  var wr: HttpWebRequest := WebRequest.Create(url) as HttpWebRequest;
  wr.ContentType := 'application/x-www-form-urlencoded';
  wr.Method := 'POST';
  wr.KeepAlive := true;
  wr.Credentials := System.Net.CredentialCache.DefaultCredentials;
  wr.ContentLength := postData.Length;

  var rs: Stream := wr.GetRequestStream();  

  var data: array of System.Byte := Encoding.UTF8.GetBytes(postData);
  rs.Write(data, 0, data.Length);    
  rs.Close();

  var wresp: WebResponse := nil;
  try
    wresp := wr.GetResponse();
    var stream2: Stream := wresp.GetResponseStream();
         
    if wresp.Headers.Item['Content-Type'] = 'application/x-download' then
    begin
      using file: Stream := File.OpenWrite(nameRes + '.pdf') do begin
       var buffer: array of System.Byte := new System.Byte[8 * 1024];
       var len: System.Int32;
       loop begin
          len := stream2.Read(buffer, 0, buffer.Length);
          file.Write(buffer, 0, len);

          if not(len > 0) then break;
        end;
       end
     end else begin  
       var reader2: StreamReader := new StreamReader(stream2);
       var sWriter: System.IO.StreamWriter := new System.IO.StreamWriter(nameRes + '.xml',true,Encoding.GetEncoding('utf-8'));
       sWriter.Write(reader2.ReadToEnd());    
       sWriter.Close();
    end;
           
    Console.WriteLine('Vysledek byl zapsan do souboru ' + nameRes);
    
  finally
    wr := nil
  except
    on ex: Exception do begin      
      Console.WriteLine('Chyba pri komunikaci se serverem: ' + ex.Message);
      if wresp <> nil then begin
        wresp.Close();
        wresp := nil
      end
    end;
  end
end;

class method ConsoleApp.Main(args: array of String);
begin

 var fileName: System.String := '';
 if args.Length = 1 then
   fileName:= args[0].Trim;

   if not File.Exists(fileName) then
   begin
     Console.WriteLine('Soubor se nepodarilo najit!');
     Console.ReadKey();
     Exit;
   end;

  var prom: ConsoleApp:= new ConsoleApp;

  var nvc: NameValueCollection := new NameValueCollection(); 

   nvc.Add('user', 'dreplech');
   nvc.Add('password', 'dreplech');   
 
   if file.Exists('response.xml') then
       file.Delete('response.xml');

   Console.WriteLine('Test nahrani souboru na server pres API');  
   prom.HttpUploadFile(SERVER + '/dopisonline/donApi.php', fileName, 'soubor', 'multipart/form-data', nvc);  
    
   var kod : System.String := prom.parseXml('response.xml','kod_objednavky');   
   var pcislo : System.String := prom.parseXml('response.xml','podaci_cislo');
 
   if kod.Length > 0 then
   begin

     nvc.Clear;   
     nvc.Add('user', 'dreplech');
     nvc.Add('password', 'dreplech');
     nvc.Add('typvystupu','xml');
     nvc.Add('zasilka','20130322123802_25820');
     nvc.Add('datum','');

     if file.Exists('prehledZasilek.xml') then
       file.Delete('prehledZasilek.xml');

     prom.HttpPost(SERVER + '/dopisonline/donPrehledZak.php', 'application/x-www-form-urlencoded', nvc,'prehledZasilek');
   
   
     nvc.Clear;   
     nvc.Add('user', 'dreplech');
     nvc.Add('password', 'dreplech');
     nvc.Add('typvystupu','xml');
     nvc.Add('podcislo', pcislo);
        
     prom.HttpPost(SERVER + '/dopisonline/podlist.php', 'application/x-www-form-urlencoded', nvc, pcislo);
   
   end;
   
   // Vypis zasilek, ktere lze stornovat
   {
     nvc.Clear;   
     nvc.Add('user', 'dreplech');
     nvc.Add('password', 'dreplech');
     nvc.Add('typ','0');
     nvc.Add('zasilka', '');
        
     prom.HttpPost(SERVER + '/dopisonline/donStorno.php', 'application/x-www-form-urlencoded', nvc, 'seznamStorno');

     exit;
   }

  Console.WriteLine('Konec');
  Console.ReadKey();
end;

end.
